<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('segmentations', 'enabled_for_users'))
        {
            Schema::table('segmentations', function (Blueprint $table) {
                $table->boolean('enabled_for_users')->nullable()->default(null);
            });
        }
        if (!Schema::hasColumn('segmentations', 'description'))
        {
            Schema::table('segmentations', function (Blueprint $table) {
                $table->text('description')->nullable()->default(null);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('segmentations', 'enabled_for_users'))
        {
            Schema::table('segmentations', function (Blueprint $table) {
                $table->dropColumn('enabled_for_users');
            });
        }
        if (Schema::hasColumn('segmentations', 'description'))
        {
            Schema::table('segmentations', function (Blueprint $table) {
                $table->dropColumn('description');
            });
        }
    }
};
