<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('send_email_template_packets')){
            Schema::create('send_email_template_packets', function (Blueprint $table) {
                $table->bigIncrements('id')->unsigned();
                $table->text('packet');
                $table->tinyInteger('status')->default(0);
                $table->text('response')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
            Schema::dropIfExists('send_email_template_packets');
    }
};
