<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('custom_fields', 'group_id')) {
            Schema::table('custom_fields', function (Blueprint $table) {
                 $table->Integer('group_id')->nullable()->after('is_deleted');
            });
        }
        if (!Schema::hasColumn('groups', 'field_order')) {
            Schema::table('groups', function (Blueprint $table) {
                 $table->Integer('field_order')->default(0)->after('user_id');
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('custom_fields', 'group_id')) {
            Schema::table('custom_fields', function (Blueprint $table) {
                $table->dropColumn('group_id');
            });
        }
        if (Schema::hasColumn('groups', 'field_order')) {
            Schema::table('groups', function (Blueprint $table) {
                $table->dropColumn('field_order');
            });
        }
    }
};
