<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('profile_fields')) {
            Schema::create('profile_fields', function (Blueprint $table) {
                $table->id();
                $table->string('name', 255)->nullable();
                $table->string('tag', 255)->unique();
                $table->string('type', 30)->nullable();
                $table->boolean('is_default')->default(false);
                $table->boolean('is_required')->default(false);
                $table->boolean('status')->default(false);
                $table->text('options')->nullable();
                $table->mediumInteger('field_order')->nullable()->default(null);
                $table->integer('user_id')->nullable();
                $table->boolean('is_deleted')->default(false);
                $table->timestamps();
            });

            // Insert default data only if the table doesn't exist yet
            DB::statement("INSERT INTO `profile_fields` (`name`, `tag`, `type`, `is_default`, `is_required`,`status`, `options`, `field_order`, `user_id`, `is_deleted`) VALUES
                ('Email', 'email', 'text', 1, 1, 1 ,NULL, 1, 2, 0),
                ('Name', 'name', 'text', 1, 1, 1, NULL, 2, 2, 0),
                ('Password', 'password', 'text', 1, 1, 1, NULL, 3, 2, 0),
                ('Country', 'country', 'text', 1, 0, 1, NULL, 4, 2, 0),
                ('Mobile', 'mobile', 'number', 1, 0, 1, NULL, 5, 2, 0),
                ('Address Line 1', 'address_line_1', 'text', 1, 0, 1, NULL, 6, 2, 0),
                ('Address Line 2', 'address_line_2', 'text', 1, 0, 1, NULL, 7, 2, 0),
                ('City', 'city', 'text', 1, 0, 1, NULL, 8, 2, 0),
                ('State', 'state', 'text', 1, 0, 1, NULL, 9, 2, 0),
                ('Post Code', 'post_code', 'number', 1, 0, 1, NULL, 10, 2, 0),
                ('Phone', 'phone', 'number', 1, 0, 1, NULL, 11, 2, 0)");
        }
        else {
            // Modify the existing table
            if (!Schema::hasColumn('profile_fields', 'name')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->string('name', 255)->nullable();
                });
            }
            if (!Schema::hasColumn('profile_fields', 'tag')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->string('tag', 255)->unique();
                });
            }
            if (!Schema::hasColumn('profile_fields', 'type')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->string('type', 30)->nullable();
                });
            }
            if (!Schema::hasColumn('profile_fields', 'is_default')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->boolean('is_default')->default(false);
                });
            }
            if (!Schema::hasColumn('profile_fields', 'is_required')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->boolean('is_required')->default(false);
                });
            }
            if (!Schema::hasColumn('profile_fields', 'status')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->boolean('status')->default(false);
                });
            }
            if (!Schema::hasColumn('profile_fields', 'options')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->text('options')->nullable();
                });
            }
            if (!Schema::hasColumn('profile_fields', 'field_order')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->mediumInteger('field_order')->nullable()->default(null);
                });
            }
            if (!Schema::hasColumn('profile_fields', 'user_id')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->integer('user_id')->nullable();
                });
            }
            if (!Schema::hasColumn('profile_fields', 'is_deleted')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->boolean('is_deleted')->default(false);
                });
            }
            if (!Schema::hasColumn('profile_fields', 'created_at')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->timestamp('created_at')->nullable()->useCurrent();
                });
            }
            if (!Schema::hasColumn('profile_fields', 'updated_at')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->timestamp('updated_at')->useCurrentOnUpdate();
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('profile_fields');
    }
};
