<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('translations', 'installed')) {
            Schema::table('translations', function (Blueprint $table) {
                $table->integer('installed')->default(0);
            });
         }
       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('translations', 'installed')) {
            Schema::table('translations', function (Blueprint $table) {
                $table->dropColumn('installed');
            });
        }
    }
};
